/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.time;

import com.ibm.hwmca.base.time.ConsoleTimeSetException;
import com.ibm.hwmca.base.time.ConsoleTimeSyncAttention;
import com.ibm.hwmca.base.time.ErrorIds;
import com.ibm.hwmca.base.time.MasterTimeSource;
import com.ibm.hwmca.base.time.TimeManager;
import com.ibm.hwmca.base.util.BaseMessageText;
import com.ibm.hwmca.base.util.BaseMessageTitle;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.attn.Attention;
import com.ibm.hwmca.fw.attn.AttentionID;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.managed.HwmcaObject;
import com.ibm.hwmca.fw.managed.ManagedObjectManager;
import com.ibm.hwmca.fw.managed.ObjectId;
import com.ibm.hwmca.fw.msgpanel.CommonMsgInterface;
import com.ibm.hwmca.fw.task.ProgressCancelListener;
import com.ibm.hwmca.fw.task.ProgressData;
import com.ibm.hwmca.fw.task.ProgressEndedListener;
import com.ibm.hwmca.fw.task.ProgressReportListenerImpl;
import com.ibm.hwmca.fw.task.ProgressStartEvent;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletProgressListener;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.tasklet.TaskletException;
import com.ibm.hwmca.fw.util.LocalizableText;
import com.ibm.hwmca.fw.util.MsgType;
import com.ibm.hwmca.fw.util.Trace;

public final class ConsoleTimeSyncAttentionTasklet
extends PanelTasklet
implements ProgressEndedListener,
ErrorIds {
    private static final String TRACE_MASKT = "XTODATTT";
    private static final String TRACE_MASKF = "XTODATTF";
    private static final String TRACE_MASKD = "XTODATTD";
    private AttentionID attentionId = null;
    private ConsoleTimeSyncAttention attn = null;
    private boolean progressDismissed = false;

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        Trace.trace(TRACE_MASKT, "-> service");
        if (request.isInitialRequest()) {
            this.processInitialRequest(request, response);
        }
        response.terminate();
        Trace.trace(TRACE_MASKT, "<- service");
    }

    public void logException(Throwable throwable) {
        Trace.trace(TRACE_MASKT, "-> logException");
        new FrameworkLog(ErrorIds.LOGINFO, 10, throwable).log();
        Trace.trace(TRACE_MASKT, "<- logException");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processInitialRequest(PanelTaskletRequest request, PanelTaskletResponse response) throws TaskletException {
        ObjectId ownerObjectId = (ObjectId)request.getData("OBJECT_ID");
        this.attentionId = (AttentionID)request.getData("ATTENTION_ID");
        boolean error = false;
        Trace.trace(TRACE_MASKF, "ObjectId=" + ownerObjectId);
        Trace.trace(TRACE_MASKF, "AttentionId=" + this.attentionId);
        this.attn = (ConsoleTimeSyncAttention)Attention.getAttention(ownerObjectId, this.attentionId);
        if (this.attn != null) {
            HwmcaObject object = ManagedObjectManager.getManagedObjectManager().get(this.attn.getMasterTimeSourceObjectId());
            if (object != null) {
                TimeManager tm = TimeManager.getTimeManager();
                MasterTimeSource masterTimeSource = null;
                try {
                    masterTimeSource = tm.getMasterTimeSourceImpl(object);
                }
                catch (HException he) {
                    Trace.trace(TRACE_MASKF, "Exception getting master time source impl: " + he);
                    this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    error = true;
                }
                if (!error) {
                    if (masterTimeSource != null) {
                        LocalizableText answer = this.showMessageBox(true, new BaseMessageTitle("TIMEATTNDETAILS.TITLE"), new BaseMessageText("TIMEATTNDETAILS.TEXT", new String[]{object.getUIInfo().getUnlocalizedName().toString()}), MsgType.QUESTION_MESSAGE, new LocalizableText[]{CommonMsgInterface.YES_BUTTON, CommonMsgInterface.NO_BUTTON, CommonMsgInterface.CANCEL_BUTTON});
                        Trace.trace(TRACE_MASKF, "Answer from user = " + answer);
                        if (answer.equals(CommonMsgInterface.YES_BUTTON)) {
                            BaseMessageTitle taskName = new BaseMessageTitle("TIMETOD.TITLE");
                            BaseMessageTitle initialText = new BaseMessageTitle("TIMEPROGRESS.TITLE");
                            String id = "1";
                            PanelTaskletProgressListener progressListener = new PanelTaskletProgressListener(this);
                            ProgressStartEvent progressStartEvent = new ProgressStartEvent(taskName, new ProgressData[]{new ProgressData()}, 0L, (LocalizableText)initialText, id, (ProgressCancelListener)null, (ProgressEndedListener)this);
                            ProgressReportListenerImpl timeProgressReportListener = new ProgressReportListenerImpl(id, null, progressListener);
                            ConsoleTimeSyncAttentionTasklet consoleTimeSyncAttentionTasklet = this;
                            synchronized (consoleTimeSyncAttentionTasklet) {
                                if (tm.setTimeChangeInProgress(true)) {
                                    try {
                                        this.progressDismissed = false;
                                        boolean progressPanelUsed = false;
                                        try {
                                            progressPanelUsed = tm.syncConsoleTime(object, masterTimeSource, progressListener, progressStartEvent, timeProgressReportListener, true);
                                            if (progressPanelUsed) {
                                                Trace.trace(TRACE_MASKF, "About to wait for progress panel to be dismissed");
                                                while (!this.progressDismissed) {
                                                    try {
                                                        this.wait();
                                                    }
                                                    catch (InterruptedException exc) {}
                                                }
                                            }
                                            Trace.trace(TRACE_MASKF, "Time sync succeeded; about to tell the user");
                                            this.showMessageBox(true, new BaseMessageTitle("IQZA0149.TITLE"), new BaseMessageText("IQZA0149.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                        }
                                        catch (ConsoleTimeSetException ctse) {
                                            if (ctse.isProgressPanelUsed()) {
                                                Trace.trace(TRACE_MASKF, "About to wait for progress panel to be dismissed");
                                                while (!this.progressDismissed) {
                                                    try {
                                                        this.wait();
                                                    }
                                                    catch (InterruptedException exc) {}
                                                }
                                            } else {
                                                Trace.trace(TRACE_MASKF, "An error occurred while syncing the console time: " + ctse);
                                                this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            }
                                            error = true;
                                        }
                                        catch (HException he) {
                                            Trace.trace(TRACE_MASKF, "Exception syncing console time: " + he);
                                            this.showMessageBox(true, new BaseMessageTitle("TIME002.TITLE"), new BaseMessageText("TIME002.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                            error = true;
                                        }
                                    }
                                    finally {
                                        tm.setTimeChangeInProgress(false);
                                    }
                                } else {
                                    Trace.trace(TRACE_MASKF, "Time change already in progress");
                                    this.showMessageBox(true, new BaseMessageTitle("TIMEINPROG.TITLE"), new BaseMessageText("TIMEINPROG.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                                    error = true;
                                }
                            }
                        }
                        if (!error && !answer.equals(CommonMsgInterface.CANCEL_BUTTON)) {
                            Attention.deleteAttention(ownerObjectId, this.attentionId);
                        }
                    } else {
                        Trace.trace(TRACE_MASKF, "Requesting object is no longer a master time source");
                        this.showMessageBox(true, new BaseMessageTitle("TIMEATTNDETAILS.TITLE"), new BaseMessageText("TIMENOTMASTER.TEXT"), MsgType.ERROR_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
                    }
                }
            } else {
                Trace.trace(TRACE_MASKF, "Object that requested time sync is gone or user not permitted");
                this.showMessageBox(true, new BaseMessageTitle("TIMEATTNDETAILS.TITLE"), new BaseMessageText("TIMEOBJECTGONE.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
            }
        } else {
            Trace.trace(TRACE_MASKF, "The attention is gone or user not permitted; ignore this request...");
            this.showMessageBox(true, new BaseMessageTitle("TIMEATTNDETAILS.TITLE"), new BaseMessageText("TIMEATTNGONE.TEXT"), MsgType.INFORMATION_MESSAGE, new LocalizableText[]{CommonMsgInterface.OK_BUTTON});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void progressEnded(String id) {
        Trace.trace(TRACE_MASKT, "-> progressEnded");
        ConsoleTimeSyncAttentionTasklet consoleTimeSyncAttentionTasklet = this;
        synchronized (consoleTimeSyncAttentionTasklet) {
            this.progressDismissed = true;
            this.notifyAll();
        }
        Trace.trace(TRACE_MASKT, "<- progressEnded");
    }
}

